<?php
// cetak_kas_bank2.php
include 'config.php';
include 'session.php';

require_once __DIR__ . '/dompdf/autoload.inc.php';
use Dompdf\Dompdf;

// Fungsi format rupiah
function format_rupiah($amount) {
    return 'Rp ' . number_format($amount, 0, ',', '.');
}

// Ambil parameter tanggal
$tanggal_awal = $_GET['tanggal_awal'] ?? date('Y-m-d');
$tanggal_akhir = $_GET['tanggal_akhir'] ?? date('Y-m-d');

// Query untuk mengambil data kas bank2 berdasarkan rentang tanggal
$query = "SELECT * FROM kas_bank2 
          WHERE tanggal BETWEEN '$tanggal_awal' AND '$tanggal_akhir' 
          ORDER BY tanggal ASC, id ASC";
$result = mysqli_query($conn, $query);
$transaksi = mysqli_fetch_all($result, MYSQLI_ASSOC);

// Hitung total
$total_masuk = 0;
$total_keluar = 0;
foreach ($transaksi as $row) {
    if ($row['jenis'] == 'masuk') {
        $total_masuk += $row['jumlah'];
    } else {
        $total_keluar += $row['jumlah'];
    }
}
$saldo_akhir = $total_masuk - $total_keluar;

// Hitung saldo awal (transaksi sebelum tanggal awal)
$query_awal = "SELECT COALESCE(SUM(CASE WHEN jenis='masuk' THEN jumlah ELSE 0 END), 0) - 
               COALESCE(SUM(CASE WHEN jenis='keluar' THEN jumlah ELSE 0 END), 0) as saldo_awal
               FROM kas_bank2 WHERE tanggal < '$tanggal_awal'";
$result_awal = mysqli_query($conn, $query_awal);
$saldo_awal = mysqli_fetch_assoc($result_awal)['saldo_awal'];

// HTML untuk PDF
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Bank Andik</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            border-bottom: 3px solid #6f42c1;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #6f42c1;
            margin-bottom: 5px;
        }
        .report-title {
            font-size: 18px;
            font-weight: bold;
            margin: 10px 0;
        }
        .bank-label {
            background: linear-gradient(135deg, #6f42c1, #e83e8c);
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }
        .period {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            background: #f8f9fa;
        }
        .summary-table th,
        .summary-table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #dee2e6;
        }
        .summary-table th {
            background-color: #6f42c1;
            color: white;
            font-weight: bold;
        }
        .detail-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .detail-table th {
            background-color: #495057;
            color: white;
            padding: 10px 8px;
            text-align: left;
            font-size: 12px;
            border: 1px solid #dee2e6;
        }
        .detail-table td {
            padding: 8px;
            border: 1px solid #dee2e6;
            font-size: 11px;
        }
        .detail-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-success { color: #198754; font-weight: bold; }
        .text-danger { color: #dc3545; font-weight: bold; }
        .text-primary { color: #6f42c1; font-weight: bold; }
        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }
        .badge-success {
            background-color: #198754;
            color: white;
        }
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        .footer {
            margin-top: 40px;
            text-align: right;
            font-size: 12px;
            color: #666;
        }
        .signature {
            margin-top: 60px;
            text-align: right;
        }
        .signature-line {
            margin-top: 80px;
            border-top: 1px solid #333;
            width: 200px;
            margin-left: auto;
            text-align: center;
            padding-top: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">SISTEM MANAJEMEN KEUANGAN</div>
        <div class="bank-label">BANK ANDIK</div>
        <div class="report-title">LAPORAN KAS BANK ANDIK</div>
        <div class="period">Periode: ' . date('d/m/Y', strtotime($tanggal_awal)) . ' - ' . date('d/m/Y', strtotime($tanggal_akhir)) . '</div>
        <div style="font-size: 12px; color: #666;">Dicetak pada: ' . date('d/m/Y H:i:s') . '</div>
    </div>

    <table class="summary-table">
        <tr>
            <th colspan="2" style="text-align: center; font-size: 16px;">RINGKASAN KEUANGAN BANK ANDIK</th>
        </tr>
        <tr>
            <td><strong>Saldo Awal Periode</strong></td>
            <td class="text-right"><strong>' . format_rupiah($saldo_awal) . '</strong></td>
        </tr>
        <tr>
            <td style="color: #198754;"><strong>Total Dana Masuk</strong></td>
            <td class="text-right text-success">' . format_rupiah($total_masuk) . '</td>
        </tr>
        <tr>
            <td style="color: #dc3545;"><strong>Total Dana Keluar</strong></td>
            <td class="text-right text-danger">' . format_rupiah($total_keluar) . '</td>
        </tr>
        <tr style="background-color: #e3f2fd;">
            <td><strong>Saldo Akhir Periode</strong></td>
            <td class="text-right text-primary" style="font-size: 16px;">' . format_rupiah($saldo_awal + $saldo_akhir) . '</td>
        </tr>
        <tr>
            <td><strong>Jumlah Transaksi</strong></td>
            <td class="text-right"><strong>' . count($transaksi) . ' transaksi</strong></td>
        </tr>
    </table>';

if (!empty($transaksi)) {
    $html .= '
    <h3 style="color: #495057; border-bottom: 2px solid #dee2e6; padding-bottom: 10px;">DETAIL TRANSAKSI BANK ANDIK</h3>
    <table class="detail-table">
        <thead>
            <tr>
                <th width="10%">No</th>
                <th width="15%">Tanggal</th>
                <th width="40%">Keterangan</th>
                <th width="12%">Jenis</th>
                <th width="15%">Jumlah</th>
                <th width="15%">Saldo</th>
            </tr>
        </thead>
        <tbody>';
    
    $no = 1;
    $saldo_berjalan = $saldo_awal;
    
    foreach ($transaksi as $row) {
        if ($row['jenis'] == 'masuk') {
            $saldo_berjalan += $row['jumlah'];
        } else {
            $saldo_berjalan -= $row['jumlah'];
        }
        
        $jenis_badge = $row['jenis'] == 'masuk' ? 
            '<span class="badge badge-success">MASUK</span>' : 
            '<span class="badge badge-danger">KELUAR</span>';
        
        $jumlah_class = $row['jenis'] == 'masuk' ? 'text-success' : 'text-danger';
        
        $html .= '
            <tr>
                <td class="text-center">' . $no++ . '</td>
                <td class="text-center">' . date('d/m/Y', strtotime($row['tanggal'])) . '</td>
                <td>' . htmlspecialchars($row['keterangan']) . '</td>
                <td class="text-center">' . $jenis_badge . '</td>
                <td class="text-right ' . $jumlah_class . '">' . format_rupiah($row['jumlah']) . '</td>
                <td class="text-right text-primary">' . format_rupiah($saldo_berjalan) . '</td>
            </tr>';
    }
    
    $html .= '
        </tbody>
    </table>';
} else {
    $html .= '
    <div style="text-align: center; padding: 40px; background-color: #f8f9fa; border-radius: 10px; margin: 20px 0;">
        <h4 style="color: #6c757d;">Tidak ada transaksi Bank Andik pada periode ini</h4>
        <p style="color: #6c757d;">Periode: ' . date('d/m/Y', strtotime($tanggal_awal)) . ' - ' . date('d/m/Y', strtotime($tanggal_akhir)) . '</p>
    </div>';
}

$html .= '
    <div class="footer">
        <p><em>Laporan ini dibuat secara otomatis oleh Sistem Manajemen Keuangan</em></p>
    </div>

    <div class="signature">
        <p>Surabaya, ' . date('d M Y') . '</p>
        <p>Mengetahui,</p>
        <div class="signature-line">
            <strong>Manager Keuangan</strong>
        </div>
    </div>
</body>
</html>';

// Generate PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Output PDF
$filename = 'Laporan_Kas_Bank_Andik_' . date('Y-m-d', strtotime($tanggal_awal)) . '_' . date('Y-m-d', strtotime($tanggal_akhir)) . '.pdf';
$dompdf->stream($filename, array('Attachment' => true));
?>