<?php
// daily_work_add.php - Add new daily work
ini_set('display_errors', 1);
error_reporting(E_ALL);

include 'config.php';
include 'session.php';

if (!isset($conn) || !$conn) {
    die('Error: Database connection tidak tersedia!');
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'] ?? '';
    $jam_masuk = $_POST['jam_masuk'] ?: null;
    $jam_pulang = $_POST['jam_pulang'] ?: null;
    $created_by = $_POST['created_by'] ?? '';
    
    $plans = $_POST['plans'] ?? [];
    $plan_results = $_POST['plan_results'] ?? [];
    $results = $_POST['results'] ?? [];
    
    // Validation
    $errors = [];
    if (empty($tanggal)) {
        $errors[] = "Tanggal harus diisi";
    }
    if (empty($created_by)) {
        $errors[] = "Nama pekerja harus diisi";
    }
    
    if (empty($errors)) {
        mysqli_begin_transaction($conn);
        
        try {
            // Insert daily work
            $sql_work = "INSERT INTO daily_work (tanggal, jam_masuk, jam_pulang, created_by) VALUES (?, ?, ?, ?)";
            $stmt_work = mysqli_prepare($conn, $sql_work);
            mysqli_stmt_bind_param($stmt_work, "ssss", $tanggal, $jam_masuk, $jam_pulang, $created_by);
            
            if (!mysqli_stmt_execute($stmt_work)) {
                throw new Exception("Gagal menyimpan daily work: " . mysqli_error($conn));
            }
            
            $daily_work_id = mysqli_insert_id($conn);
            
            // Insert plans dan hasil
            if (!empty($plans)) {
                $sql_plan = "INSERT INTO daily_work_plans (daily_work_id, subject, detail, urutan) VALUES (?, ?, ?, ?)";
                $stmt_plan = mysqli_prepare($conn, $sql_plan);
                
                foreach ($plans as $index => $plan) {
                    if (!empty($plan['subject'])) {
                        $urutan = $index + 1;
                        mysqli_stmt_bind_param($stmt_plan, "issi", $daily_work_id, $plan['subject'], $plan['detail'], $urutan);
                        if (!mysqli_stmt_execute($stmt_plan)) {
                            throw new Exception("Gagal menyimpan plan: " . mysqli_error($conn));
                        }
                        $plan_id = mysqli_insert_id($conn);
                        
                        // Insert hasil untuk plan ini jika ada
                        if (!empty($plan_results[$index]['detail']) || !empty($plan_results[$index]['status'])) {
                            $sql_plan_result = "INSERT INTO daily_work_results (daily_work_id, plan_id, subject, detail, status, urutan) VALUES (?, ?, ?, ?, ?, ?)";
                            $stmt_plan_result = mysqli_prepare($conn, $sql_plan_result);
                            $result_status = $plan_results[$index]['status'] ?: 'completed';
                            $result_subject = $plan['subject']; // Gunakan subject dari plan
                            mysqli_stmt_bind_param($stmt_plan_result, "iisssi", $daily_work_id, $plan_id, $result_subject, $plan_results[$index]['detail'], $result_status, $urutan);
                            if (!mysqli_stmt_execute($stmt_plan_result)) {
                                throw new Exception("Gagal menyimpan hasil plan: " . mysqli_error($conn));
                            }
                        }
                    }
                }
            }
            
            // Insert hasil tambahan
            if (!empty($results)) {
                $sql_result = "INSERT INTO daily_work_results (daily_work_id, subject, detail, status, urutan) VALUES (?, ?, ?, ?, ?)";
                $stmt_result = mysqli_prepare($conn, $sql_result);
                
                $additional_urutan = count($plans) + 1;
                foreach ($results as $index => $result) {
                    if (!empty($result['subject'])) {
                        $status = $result['status'] ?: 'completed';
                        mysqli_stmt_bind_param($stmt_result, "isssi", $daily_work_id, $result['subject'], $result['detail'], $status, $additional_urutan);
                        if (!mysqli_stmt_execute($stmt_result)) {
                            throw new Exception("Gagal menyimpan hasil tambahan: " . mysqli_error($conn));
                        }
                        $additional_urutan++;
                    }
                }
            }
            
            mysqli_commit($conn);
            $_SESSION['success_message'] = "Daily work berhasil ditambahkan!";
            header('Location: daily_work_list.php');
            exit();
            
        } catch (Exception $e) {
            mysqli_rollback($conn);
            $errors[] = $e->getMessage();
        }
    }
}

// Form data - jika ada error, pertahankan input
$form_data = [
    'tanggal' => $_POST['tanggal'] ?? date('Y-m-d'),
    'jam_masuk' => $_POST['jam_masuk'] ?? '',
    'jam_pulang' => $_POST['jam_pulang'] ?? '',
    'created_by' => $_POST['created_by'] ?? '',
    'plans' => $_POST['plans'] ?? [['subject' => '', 'detail' => '']],
    'plan_results' => $_POST['plan_results'] ?? [['subject' => '', 'detail' => '', 'status' => '']],
    'results' => $_POST['results'] ?? []
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Daily Work</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        .card-header {
            background: linear-gradient(135deg, #0066cc 0%, #0080ff 100%);
            color: white;
        }
        .dynamic-section {
            border: 2px dashed #dee2e6;
            border-radius: 8px;
            padding: 20px;
            margin: 15px 0;
            background-color: #f8f9fa;
        }
        .item-card {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            background-color: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .remove-btn {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        .add-btn {
            border: 2px dashed #0066cc;
            color: #0066cc;
            background: none;
            padding: 15px;
            border-radius: 8px;
            width: 100%;
            margin-top: 10px;
            transition: all 0.3s;
        }
        .add-btn:hover {
            background-color: #0066cc;
            color: white;
        }
    </style>
</head>
<body>

<?php if (file_exists('navbar.php')) include 'navbar.php'; ?>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            
            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <h6>Terjadi kesalahan:</h6>
                    <ul class="mb-0">
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo htmlspecialchars($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <div class="card shadow">
                <div class="card-header">
                    <h4 class="mb-0">
                        <i class="fa fa-plus"></i> Tambah Daily Work Plan & Results
                    </h4>
                </div>
                <div class="card-body">
                    <form method="POST" id="dailyWorkForm">
                        
                        <!-- Basic Information -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label for="tanggal" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="tanggal" name="tanggal" 
                                       value="<?php echo htmlspecialchars($form_data['tanggal']); ?>" required>
                            </div>
                            <div class="col-md-3">
                                <label for="jam_masuk" class="form-label">Jam Masuk</label>
                                <input type="time" class="form-control" id="jam_masuk" name="jam_masuk" 
                                       value="<?php echo htmlspecialchars($form_data['jam_masuk']); ?>">
                            </div>
                            <div class="col-md-3">
                                <label for="jam_pulang" class="form-label">Jam Pulang</label>
                                <input type="time" class="form-control" id="jam_pulang" name="jam_pulang" 
                                       value="<?php echo htmlspecialchars($form_data['jam_pulang']); ?>">
                            </div>
                            <div class="col-md-2">
                                <label for="created_by" class="form-label">Nama <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="created_by" name="created_by" 
                                       placeholder="Isaac" value="<?php echo htmlspecialchars($form_data['created_by']); ?>" required>
                            </div>
                        </div>

                        <!-- Work Plans Section -->
                        <div class="dynamic-section">
                            <h5 class="text-primary mb-3">
                                <i class="fa fa-list-alt"></i> Plan Pekerjaan & Hasil
                            </h5>
                            <div id="plansContainer">
                                <?php foreach ($form_data['plans'] as $index => $plan): ?>
                                    <div class="item-card position-relative" data-type="plan">
                                        <button type="button" class="btn btn-sm btn-danger remove-btn" onclick="removeItem(this)">
                                            <i class="fa fa-times"></i>
                                        </button>
                                        <div class="row">
                                            <!-- Plan Section -->
                                            <div class="col-md-12 mb-3">
                                                <div class="bg-light p-3 rounded">
                                                    <h6 class="text-primary mb-2"><i class="fa fa-target"></i> Plan Pekerjaan</h6>
                                                    <div class="row">
                                                        <div class="col-md-12 mb-2">
                                                            <label class="form-label">Subject Plan</label>
                                                            <input type="text" class="form-control" name="plans[<?php echo $index; ?>][subject]" 
                                                                   placeholder="Contoh: Kirim penagihan ke Dinda (Dewata)" 
                                                                   value="<?php echo htmlspecialchars($plan['subject']); ?>">
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label class="form-label">Detail Plan</label>
                                                            <textarea class="form-control" name="plans[<?php echo $index; ?>][detail]" rows="2" 
                                                                      placeholder="Detail lengkap plan pekerjaan..."><?php echo htmlspecialchars($plan['detail']); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Result Section for this Plan -->
                                            <div class="col-md-12">
                                                <div class="bg-primary bg-opacity-10 p-3 rounded">
                                                    <h6 class="text-primary mb-2"><i class="fa fa-check-circle"></i> Hasil dari Plan Ini</h6>
                                                    <div class="row">
                                                        <div class="col-md-4 mb-2">
                                                            <label class="form-label">Status</label>
                                                            <select class="form-select" name="plan_results[<?php echo $index; ?>][status]">
                                                                <option value="">Belum Dikerjakan</option>
                                                                <option value="completed" <?php echo ($form_data['plan_results'][$index]['status'] ?? '') == 'completed' ? 'selected' : ''; ?>>Selesai</option>
                                                                <option value="in_progress" <?php echo ($form_data['plan_results'][$index]['status'] ?? '') == 'in_progress' ? 'selected' : ''; ?>>Dalam Proses</option>
                                                                <option value="pending" <?php echo ($form_data['plan_results'][$index]['status'] ?? '') == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                                <option value="cancelled" <?php echo ($form_data['plan_results'][$index]['status'] ?? '') == 'cancelled' ? 'selected' : ''; ?>>Dibatalkan</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-md-8">
                                                            <label class="form-label">Detail Hasil</label>
                                                            <textarea class="form-control" name="plan_results[<?php echo $index; ?>][detail]" rows="2" 
                                                                      placeholder="Jelaskan hasil pengerjaan plan ini..."><?php echo htmlspecialchars($form_data['plan_results'][$index]['detail'] ?? ''); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="add-btn" onclick="addPlanItem()">
                                <i class="fa fa-plus"></i> Tambah Plan & Hasil Lainnya
                            </button>
                        </div>

                        <!-- Additional Work Results Section -->
                        <div class="dynamic-section">
                            <h5 class="text-warning mb-3">
                                <i class="fa fa-plus-square"></i> Hasil Pekerjaan Tambahan
                            </h5>
                            <p class="text-muted mb-3">
                                <small><i class="fa fa-info-circle"></i> Gunakan section ini untuk hasil pekerjaan yang tidak terkait dengan plan di atas, atau pekerjaan tambahan yang muncul mendadak.</small>
                            </p>
                            <div id="resultsContainer">
                                <?php if (!empty($form_data['results'])): ?>
                                    <?php foreach ($form_data['results'] as $index => $result): ?>
                                        <div class="item-card position-relative" data-type="result">
                                            <button type="button" class="btn btn-sm btn-danger remove-btn" onclick="removeItem(this)">
                                                <i class="fa fa-times"></i>
                                            </button>
                                            <div class="row">
                                                <div class="col-md-8 mb-2">
                                                    <label class="form-label">Subject Hasil Tambahan</label>
                                                    <input type="text" class="form-control" name="results[<?php echo $index; ?>][subject]" 
                                                           placeholder="Contoh: Handling komplain customer XYZ" 
                                                           value="<?php echo htmlspecialchars($result['subject']); ?>">
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label class="form-label">Status</label>
                                                    <select class="form-select" name="results[<?php echo $index; ?>][status]">
                                                        <option value="completed" <?php echo ($result['status'] ?? 'completed') == 'completed' ? 'selected' : ''; ?>>Selesai</option>
                                                        <option value="in_progress" <?php echo ($result['status'] ?? '') == 'in_progress' ? 'selected' : ''; ?>>Dalam Proses</option>
                                                        <option value="pending" <?php echo ($result['status'] ?? '') == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                        <option value="cancelled" <?php echo ($result['status'] ?? '') == 'cancelled' ? 'selected' : ''; ?>>Dibatalkan</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12">
                                                    <label class="form-label">Detail Hasil</label>
                                                    <textarea class="form-control" name="results[<?php echo $index; ?>][detail]" rows="2" 
                                                              placeholder="Detail hasil pekerjaan tambahan..."><?php echo htmlspecialchars($result['detail']); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="add-btn" onclick="addResultItem()">
                                <i class="fa fa-plus"></i> Tambah Hasil Tambahan Lainnya
                            </button>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-between mt-4">
                            <a href="daily_work_list.php" class="btn btn-secondary">
                                <i class="fa fa-arrow-left"></i> Kembali
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-save"></i> Simpan Daily Work
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
let planIndex = <?php echo count($form_data['plans']); ?>;
let resultIndex = <?php echo count($form_data['results']); ?>;

function addPlanItem() {
    const container = document.getElementById('plansContainer');
    const itemHtml = `
        <div class="item-card position-relative" data-type="plan">
            <button type="button" class="btn btn-sm btn-danger remove-btn" onclick="removeItem(this)">
                <i class="fa fa-times"></i>
            </button>
            <div class="row">
                <!-- Plan Section -->
                <div class="col-md-12 mb-3">
                    <div class="bg-light p-3 rounded">
                        <h6 class="text-success mb-2"><i class="fa fa-target"></i> Plan Pekerjaan</h6>
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <label class="form-label">Subject Plan</label>
                                <input type="text" class="form-control" name="plans[${planIndex}][subject]" 
                                       placeholder="Contoh: Kirim penagihan ke Dinda (Dewata)">
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Detail Plan</label>
                                <textarea class="form-control" name="plans[${planIndex}][detail]" rows="2" 
                                          placeholder="Detail lengkap plan pekerjaan..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Result Section for this Plan -->
                <div class="col-md-12">
                    <div class="bg-primary bg-opacity-10 p-3 rounded">
                        <h6 class="text-primary mb-2"><i class="fa fa-check-circle"></i> Hasil dari Plan Ini</h6>
                        <div class="row">
                            <div class="col-md-8 mb-2">
                                <label class="form-label">Subject Hasil</label>
                                <input type="text" class="form-control" name="plan_results[${planIndex}][subject]" 
                                       placeholder="Hasil dari plan ini...">
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="plan_results[${planIndex}][status]">
                                    <option value="">Belum Dikerjakan</option>
                                    <option value="completed">Selesai</option>
                                    <option value="in_progress">Dalam Proses</option>
                                    <option value="pending">Pending</option>
                                    <option value="cancelled">Dibatalkan</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Detail Hasil</label>
                                <textarea class="form-control" name="plan_results[${planIndex}][detail]" rows="2" 
                                          placeholder="Jelaskan hasil pengerjaan plan ini..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', itemHtml);
    planIndex++;
}

function addResultItem() {
    const container = document.getElementById('resultsContainer');
    const itemHtml = `
        <div class="item-card position-relative" data-type="result">
            <button type="button" class="btn btn-sm btn-danger remove-btn" onclick="removeItem(this)">
                <i class="fa fa-times"></i>
            </button>
            <div class="row">
                <div class="col-md-8 mb-2">
                    <label class="form-label">Subject Hasil Tambahan</label>
                    <input type="text" class="form-control" name="results[${resultIndex}][subject]" 
                           placeholder="Contoh: Handling komplain customer XYZ">
                </div>
                <div class="col-md-4 mb-2">
                    <label class="form-label">Status</label>
                    <select class="form-select" name="results[${resultIndex}][status]">
                        <option value="completed">Selesai</option>
                        <option value="in_progress">Dalam Proses</option>
                        <option value="pending">Pending</option>
                        <option value="cancelled">Dibatalkan</option>
                    </select>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Detail Hasil</label>
                    <textarea class="form-control" name="results[${resultIndex}][detail]" rows="2" 
                              placeholder="Detail hasil pekerjaan tambahan..."></textarea>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', itemHtml);
    resultIndex++;
}

function removeItem(button) {
    const itemCard = button.closest('.item-card');
    const container = itemCard.parentElement;
    
    if (container.querySelectorAll('.item-card').length > 1) {
        itemCard.remove();
    } else {
        alert('Minimal harus ada satu item');
    }
}

// Form validation
document.getElementById('dailyWorkForm').addEventListener('submit', function(e) {
    const tanggal = document.getElementById('tanggal').value;
    const createdBy = document.getElementById('created_by').value;
    
    if (!tanggal || !createdBy) {
        e.preventDefault();
        alert('Tanggal dan Nama pekerja harus diisi!');
        return false;
    }
});
</script>

</body>
</html>