<?php
// daily_work_print.php - Print view
ini_set('display_errors', 1);
error_reporting(E_ALL);

include 'config.php';
include 'session.php';

$daily_work_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$daily_work_id) {
    die('ID daily work tidak valid');
}

// Get daily work data
$sql_work = "
    SELECT 
        dw.*,
        COUNT(DISTINCT dwp.id) as total_plans,
        COUNT(DISTINCT dwr.id) as total_results,
        COUNT(DISTINCT CASE WHEN dwr.status = 'completed' THEN dwr.id END) as completed_results
    FROM daily_work dw
    LEFT JOIN daily_work_plans dwp ON dw.id = dwp.daily_work_id
    LEFT JOIN daily_work_results dwr ON dw.id = dwr.daily_work_id
    WHERE dw.id = ?
    GROUP BY dw.id
";

$stmt_work = mysqli_prepare($conn, $sql_work);
mysqli_stmt_bind_param($stmt_work, "i", $daily_work_id);
mysqli_stmt_execute($stmt_work);
$result_work = mysqli_stmt_get_result($stmt_work);
$daily_work = mysqli_fetch_assoc($result_work);

if (!$daily_work) {
    die('Daily work tidak ditemukan');
}

// Get plans
$sql_plans = "SELECT * FROM daily_work_plans WHERE daily_work_id = ? ORDER BY urutan ASC, id ASC";
$stmt_plans = mysqli_prepare($conn, $sql_plans);
mysqli_stmt_bind_param($stmt_plans, "i", $daily_work_id);
mysqli_stmt_execute($stmt_plans);
$result_plans = mysqli_stmt_get_result($stmt_plans);
$plans = [];
while ($row = mysqli_fetch_assoc($result_plans)) {
    $plans[] = $row;
}

// Get results
$sql_results = "SELECT * FROM daily_work_results WHERE daily_work_id = ? ORDER BY urutan ASC, id ASC";
$stmt_results = mysqli_prepare($conn, $sql_results);
mysqli_stmt_bind_param($stmt_results, "i", $daily_work_id);
mysqli_stmt_execute($stmt_results);
$result_results = mysqli_stmt_get_result($stmt_results);
$results = [];
while ($row = mysqli_fetch_assoc($result_results)) {
    $results[] = $row;
}

// Calculate work duration
$work_duration = '';
if ($daily_work['jam_masuk'] && $daily_work['jam_pulang']) {
    $start = new DateTime($daily_work['jam_masuk']);
    $end = new DateTime($daily_work['jam_pulang']);
    $diff = $start->diff($end);
    $work_duration = $diff->h . ' jam ' . $diff->i . ' menit';
}

// Set Indonesian day names
$day_names = [
    'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa', 'Wednesday' => 'Rabu',
    'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'
];

$day_name = $day_names[date('l', strtotime($daily_work['tanggal']))];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Work Report - <?php echo date('d M Y', strtotime($daily_work['tanggal'])); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        body { 
            font-family: 'Arial', sans-serif; 
            font-size: 12pt; 
            line-height: 1.4; 
            color: #333; 
        }
        
        .header-section { 
            text-align: center; 
            border-bottom: 3px solid #0066cc; 
            padding-bottom: 20px; 
            margin-bottom: 30px; 
        }
        
        .company-logo { 
            font-size: 20pt; 
            font-weight: bold; 
            color: #0066cc; 
            margin: 0;
            line-height: 1.2;
        }
        
        .report-title { 
            font-size: 18pt; 
            font-weight: bold; 
            color: #333; 
            margin: 10px 0; 
        }
        
        .info-table { 
            width: 100%; 
            margin-bottom: 25px; 
        }
        
        .info-table td { 
            padding: 8px 15px; 
            border: 1px solid #ddd; 
            vertical-align: top; 
        }
        
        .info-label { 
            font-weight: bold; 
            background-color: #f8f9fa; 
            width: 150px; 
        }
        
        .section-header { 
            background: linear-gradient(135deg, #0066cc, #0080ff); 
            color: white; 
            padding: 12px 20px; 
            border-radius: 8px; 
            font-weight: bold; 
            font-size: 14pt; 
            margin: 25px 0 15px 0; 
            display: flex; 
            align-items: center; 
        }
        
        .section-header i { 
            margin-right: 10px; 
        }
        
        .item-box { 
            border: 1px solid #ddd; 
            border-radius: 8px; 
            padding: 18px; 
            margin-bottom: 18px; 
            background-color: #fafafa; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .item-number { 
            font-weight: bold; 
            color: #0066cc; 
            font-size: 14pt; 
        }
        
        .item-subject { 
            font-weight: bold; 
            font-size: 12pt; 
            color: #333; 
            margin: 5px 0; 
        }
        
        .item-detail { 
            color: #666; 
            font-size: 11pt; 
            line-height: 1.6; 
            margin-top: 10px; 
            padding-left: 0px;
            border-left: 3px solid #b3d9ff;
            padding-left: 12px;
        }
        
        .status-badge { 
            display: inline-block; 
            padding: 4px 12px; 
            border-radius: 20px; 
            font-size: 10pt; 
            font-weight: bold; 
            text-transform: uppercase; 
        }
        
        .status-completed { background-color: #d4edda; color: #155724; }
        .status-in_progress { background-color: #fff3cd; color: #856404; }
        .status-pending { background-color: #f8d7da; color: #721c24; }
        .status-cancelled { background-color: #f1f3f4; color: #6c757d; }
        
        .summary-box { 
            background-color: #e6f3ff; 
            border: 1px solid #0066cc; 
            border-radius: 8px; 
            padding: 15px; 
            margin: 20px 0; 
        }
        
        .summary-title { 
            font-weight: bold; 
            color: #0066cc; 
            font-size: 13pt; 
            margin-bottom: 10px; 
        }
        
        .summary-item { 
            display: flex; 
            justify-content: space-between; 
            margin: 5px 0; 
        }
        
        .footer-section { 
            margin-top: 40px; 
            border-top: 2px solid #0066cc; 
            padding-top: 20px; 
            text-align: center; 
            color: #666; 
        }
        
        .no-data { 
            text-align: center; 
            color: #999; 
            font-style: italic; 
            padding: 30px; 
            background-color: #f8f9fa; 
            border-radius: 8px; 
            border: 1px dashed #ddd; 
        }
        
        @media print { 
            body { margin: 0; padding: 15px; } 
            .no-print { display: none !important; } 
            .page-break { page-break-before: always; }
            img { max-height: 50px !important; }
        }
    </style>
</head>
<body>

<!-- Header Section -->
<div class="header-section">
    <div style="display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
        <img src="logo.png" alt="Sumber Berkat Anak" style="height: 60px; margin-right: 15px;" onerror="this.style.display='none'">
        <div>
            <div class="company-logo">SUMBER BERKAT ANAK</div>
            <div style="font-size: 12pt; color: #666; margin-top: 5px;">CV. Sumber Berkat Anak</div>
        </div>
    </div>
    <div class="report-title">DAILY WORK PLAN & RESULTS</div>
    <div style="font-size: 12pt; color: #666;">
        Laporan Harian Aktivitas Kerja
    </div>
</div>

<!-- Basic Information -->
<table class="info-table">
    <tr>
        <td class="info-label"><i class="fa fa-calendar"></i> Tanggal</td>
        <td><?php echo $day_name . ', ' . date('d F Y', strtotime($daily_work['tanggal'])); ?></td>
        <td class="info-label"><i class="fa fa-user"></i> Nama Pekerja</td>
        <td><?php echo htmlspecialchars($daily_work['created_by']); ?></td>
    </tr>
    <tr>
        <td class="info-label"><i class="fa fa-clock"></i> Jam Masuk</td>
        <td><?php echo $daily_work['jam_masuk'] ? date('H:i', strtotime($daily_work['jam_masuk'])) : '-'; ?></td>
        <td class="info-label"><i class="fa fa-clock"></i> Jam Pulang</td>
        <td><?php echo $daily_work['jam_pulang'] ? date('H:i', strtotime($daily_work['jam_pulang'])) : '-'; ?></td>
    </tr>
    <tr>
        <td class="info-label"><i class="fa fa-hourglass-half"></i> Durasi Kerja</td>
        <td><?php echo $work_duration ?: '-'; ?></td>
        <td class="info-label"><i class="fa fa-calendar-plus"></i> Dibuat</td>
        <td><?php echo date('d M Y H:i', strtotime($daily_work['created_at'])); ?></td>
    </tr>
</table>

<!-- Summary Box -->
<div class="summary-box">
    <div class="summary-title"><i class="fa fa-chart-pie"></i> Ringkasan Aktivitas</div>
    <div class="summary-item">
        <span>Total Plan Pekerjaan:</span>
        <strong><?php echo $daily_work['total_plans']; ?> items</strong>
    </div>
    <div class="summary-item">
        <span>Total Hasil Pekerjaan:</span>
        <strong><?php echo $daily_work['total_results']; ?> items</strong>
    </div>
    <div class="summary-item">
        <span>Hasil Selesai:</span>
        <strong><?php echo $daily_work['completed_results']; ?> items</strong>
    </div>
    <div class="summary-item">
        <span>Tingkat Penyelesaian:</span>
        <strong>
            <?php 
            $completion_rate = $daily_work['total_plans'] > 0 ? 
                round(($daily_work['completed_results'] / $daily_work['total_plans']) * 100) : 0;
            echo $completion_rate . '%';
            ?>
        </strong>
    </div>
</div>

<!-- Work Plans & Results Section -->
<div class="section-header">
    <i class="fa fa-list-alt"></i> PLAN PEKERJAAN & HASIL
</div>

<?php if (!empty($plans)): ?>
    <?php foreach ($plans as $index => $plan): ?>
        <div class="item-box">
            <div class="item-number"><?php echo ($index + 1); ?>.</div>
            <div class="item-subject"><?php echo htmlspecialchars($plan['subject']); ?></div>
            <?php if ($plan['detail']): ?>
                <div class="item-detail">
                    <strong>Detail Plan:</strong><br>
                    <?php echo nl2br(htmlspecialchars($plan['detail'])); ?>
                </div>
            <?php endif; ?>
            
            <?php 
            // Cari hasil yang terkait dengan plan ini
            $plan_result = null;
            foreach ($results as $result) {
                if ($result['plan_id'] == $plan['id']) {
                    $plan_result = $result;
                    break;
                }
            }
            ?>
            
            <?php if ($plan_result): ?>
                <div style="margin-top: 15px; padding: 12px; background-color: #e6f3ff; border-left: 4px solid #0066cc; border-radius: 6px;">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                        <strong style="color: #004499; font-size: 11pt;"><i class="fa fa-check-circle"></i> Hasil Pengerjaan:</strong>
                        <span class="status-badge status-<?php echo $plan_result['status']; ?>">
                            <?php 
                            $status_labels = [
                                'completed' => 'Selesai',
                                'in_progress' => 'Dalam Proses',
                                'pending' => 'Pending',
                                'cancelled' => 'Dibatalkan'
                            ];
                            echo $status_labels[$plan_result['status']] ?? $plan_result['status'];
                            ?>
                        </span>
                    </div>
                    <?php if ($plan_result['detail']): ?>
                        <div style="color: #004499; font-size: 11pt; line-height: 1.5;">
                            <?php echo nl2br(htmlspecialchars($plan_result['detail'])); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div style="margin-top: 15px; padding: 12px; background-color: #fff3cd; border-left: 4px solid #ffc107; border-radius: 6px;">
                    <span style="color: #856404; font-style: italic; font-size: 11pt;"><i class="fa fa-clock"></i> Belum ada hasil untuk plan ini</span>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="no-data">
        <i class="fa fa-info-circle fa-2x"></i><br>
        Tidak ada plan pekerjaan yang tercatat
    </div>
<?php endif; ?>

<!-- Additional Work Results Section -->
<?php 
// Filter hasil yang tidak terkait plan (plan_id = NULL)
$additional_results = array_filter($results, function($result) {
    return $result['plan_id'] === null || $result['plan_id'] == '';
});
?>

<?php if (!empty($additional_results)): ?>
    <div class="section-header" style="margin-top: 35px;">
        <i class="fa fa-plus-square"></i> HASIL PEKERJAAN TAMBAHAN
    </div>
    
    <?php $additional_index = 1; ?>
    <?php foreach ($additional_results as $result): ?>
        <div class="item-box">
            <div style="display: flex; justify-content: space-between; align-items: flex-start;">
                <div style="flex: 1;">
                    <div class="item-number"><?php echo $additional_index; ?>.</div>
                    <div class="item-subject"><?php echo htmlspecialchars($result['subject']); ?></div>
                    <?php if ($result['detail']): ?>
                        <div class="item-detail">
                            <?php echo nl2br(htmlspecialchars($result['detail'])); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div>
                    <span class="status-badge status-<?php echo $result['status']; ?>">
                        <?php 
                        $status_labels = [
                            'completed' => 'Selesai',
                            'in_progress' => 'Dalam Proses',
                            'pending' => 'Pending',
                            'cancelled' => 'Dibatalkan'
                        ];
                        echo $status_labels[$result['status']] ?? $result['status'];
                        ?>
                    </span>
                </div>
            </div>
        </div>
        <?php $additional_index++; ?>
    <?php endforeach; ?>
<?php endif; ?>

<!-- Footer Section -->
<div class="footer-section">
    <p><strong>Daily Work Report - CV. Sumber Berkat Anak</strong></p>
    <p>Dicetak pada: <?php echo date('d F Y, H:i'); ?> WIB</p>
    <p style="font-size: 10pt; color: #999;">
        Dokumen ini digenerate secara otomatis dari sistem Daily Work Management
    </p>
    <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #ddd;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="text-align: left;">
                <p style="margin: 0; font-size: 10pt; color: #666;">Dibuat oleh:</p>
                <p style="margin: 0; font-weight: bold;"><?php echo htmlspecialchars($daily_work['created_by']); ?></p>
            </div>
            <div style="text-align: right;">
                <p style="margin: 0; font-size: 10pt; color: #666;">Tanggal:</p>
                <p style="margin: 0; font-weight: bold;"><?php echo date('d F Y', strtotime($daily_work['tanggal'])); ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Print Button (hidden when printing) -->
<div class="no-print" style="position: fixed; top: 20px; right: 20px;">
    <button onclick="window.print()" class="btn btn-success">
        <i class="fa fa-print"></i> Cetak
    </button>
    <button onclick="window.close()" class="btn btn-secondary ms-2">
        <i class="fa fa-times"></i> Tutup
    </button>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const printBtn = document.querySelector('button[onclick="window.print()"]');
    if (printBtn) printBtn.focus();
});
</script>

</body>
</html>