<?php
session_start();
include 'config.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Check if this is edit mode
$edit_mode = isset($_GET['id']) && !empty($_GET['id']);
$draft_id = $edit_mode ? intval($_GET['id']) : 0;
$draft = null;
$details = [];

if ($edit_mode) {
    // Get draft data for edit
    $header_query = "SELECT dp.*, c.nama as customer_nama 
                     FROM draft_penjualan dp
                     LEFT JOIN customer c ON dp.customer_id = c.id
                     WHERE dp.id = $draft_id";
    $header_result = mysqli_query($conn, $header_query);
    
    if (mysqli_num_rows($header_result) > 0) {
        $draft = mysqli_fetch_assoc($header_result);
        
        // Get details
        $details_query = "SELECT * FROM draft_penjualan_detail WHERE draft_id = $draft_id ORDER BY urutan ASC";
        $details_result = mysqli_query($conn, $details_query);
        
        while ($detail = mysqli_fetch_assoc($details_result)) {
            $details[] = $detail;
        }
    } else {
        header("Location: draft_penjualan_list.php?error=2");
        exit();
    }
}

// Get customers for dropdown
$customers_query = "SELECT id, kode, nama, nama_toko, kota FROM customer WHERE aktif = 1 ORDER BY nama ASC";
$customers_result = mysqli_query($conn, $customers_query);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'];
    $customer_id = $_POST['customer_id'];
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    
    if ($edit_mode) {
        // Update existing draft
        $update_header = "UPDATE draft_penjualan SET tanggal='$tanggal', customer_id='$customer_id', keterangan='$keterangan' WHERE id = $draft_id";
        mysqli_query($conn, $update_header);
        
        // Delete existing details
        mysqli_query($conn, "DELETE FROM draft_penjualan_detail WHERE draft_id = $draft_id");
        $current_draft_id = $draft_id;
        $redirect_url = "draft_penjualan_form.php?id=$draft_id&updated=1";
    } else {
        // Insert new draft
        $insert_header = "INSERT INTO draft_penjualan (tanggal, customer_id, keterangan) VALUES ('$tanggal', '$customer_id', '$keterangan')";
        mysqli_query($conn, $insert_header);
        $current_draft_id = mysqli_insert_id($conn);
        $redirect_url = "draft_penjualan_list.php?success=1";
    }
    
    // Insert details
    $total_amount = 0;
    if (isset($_POST['nama_barang']) && is_array($_POST['nama_barang'])) {
        for ($i = 0; $i < count($_POST['nama_barang']); $i++) {
            $nama_barang = mysqli_real_escape_string($conn, $_POST['nama_barang'][$i]);
            $jumlah = floatval($_POST['jumlah'][$i]);
            $harga_jual = floatval($_POST['harga_jual'][$i]);
            $harga_beli = floatval($_POST['harga_beli'][$i]);
            
            if (!empty($nama_barang) && $jumlah > 0 && $harga_jual > 0) {
                $insert_detail = "INSERT INTO draft_penjualan_detail (draft_id, nama_barang, jumlah, harga_jual, harga_beli, urutan) 
                                VALUES ('$current_draft_id', '$nama_barang', '$jumlah', '$harga_jual', '$harga_beli', " . ($i + 1) . ")";
                mysqli_query($conn, $insert_detail);
                
                $total_amount += ($jumlah * $harga_jual);
            }
        }
    }
    
    // Update total amount
    mysqli_query($conn, "UPDATE draft_penjualan SET total_amount = '$total_amount' WHERE id = '$current_draft_id'");
    
    header("Location: $redirect_url");
    exit();
}

$page_title = $edit_mode ? "Edit Draft Penjualan #" . str_pad($draft_id, 4, '0', STR_PAD_LEFT) : "Tambah Draft Penjualan";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - SBA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding: 20px;
        }
        .table-input {
            font-size: 14px;
        }
        .table-input input, .table-input textarea {
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 5px 8px;
        }
        .margin-red { background-color: #ffebee !important; }
        .margin-yellow { background-color: #fff9c4 !important; }
        .margin-green { background-color: #e8f5e8 !important; }
        .referensi-harga {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            font-size: 14px;
            cursor: pointer;
            min-height: 120px;
        }
        .referensi-harga:hover {
            background-color: #e9ecef;
        }
        .action-buttons {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        @media print {
            .no-print { display: none !important; }
            body { font-size: 12px; }
            .print-header { 
                text-align: center; 
                margin-bottom: 30px; 
                border-bottom: 2px solid #333;
                padding-bottom: 20px;
            }
        }
        
        .customer-option {
    border-bottom: 1px solid #f0f0f0;
}

.customer-option:hover {
    background-color: #f8f9fa;
}

.customer-option:last-child {
    border-bottom: none;
}

.dropdown-menu {
    border: 1px solid #ced4da;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.customer-option.active {
    background-color: #0d6efd;
    color: white;
}

.customer-option.active small {
    color: #e3f2fd !important;
}

#customerSearch:focus {
    border-color: #86b7fe;
    outline: 0;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.dropdown-menu li:first-child {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
}
    </style>
</head>
<body>
    <div class="no-print">
        <?php include 'navbar.php'; ?>
    </div>
    
    <div class="container-fluid mt-4">
        <div class="form-container">
            
            <!-- Print Header (hidden on screen) -->
            <?php if ($edit_mode): ?>
            <div class="print-header d-none d-print-block">
                <div class="row">
                    <div class="col-2">
                        <img src="logo.png" alt="SBA Logo" style="max-width: 80px;">
                    </div>
                    <div class="col-8">
                        <h2><strong>SBA</strong></h2>
                        <p>Telp: 082381757525</p>
                        <h4>PENAWARAN HARGA</h4>
                    </div>
                    <div class="col-2 text-end">
                        <p>Tanggal: <?php echo date('d/m/Y', strtotime($draft['tanggal'])); ?></p>
                        <p>No: <?php echo str_pad($draft['id'], 4, '0', STR_PAD_LEFT); ?></p>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <p><strong>Kepada: <?php echo $draft['customer_nama']; ?></strong></p>
                        <?php if (!empty($draft['keterangan'])): ?>
                        <p>Keterangan: <?php echo $draft['keterangan']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Screen Header -->
            <div class="no-print">
                <h2 class="mb-4"><?php echo $page_title; ?></h2>
                
                <?php if (isset($_GET['updated'])): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    Draft berhasil diperbarui!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <?php if ($edit_mode): ?>
                <!-- Action Buttons for Edit Mode -->
                <div class="action-buttons text-center">
                    <button type="button" class="btn btn-success me-2" id="copyWABtn">
                        Copy WA
                    </button>
                    <button type="button" class="btn btn-info me-2" onclick="window.print()">
                        Print
                    </button>
                    <a href="draft_penjualan_list.php" class="btn btn-secondary">
                        Kembali
                    </a>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Referensi Harga Box -->
            <div class="row mb-4 no-print">
                <div class="col-md-12">
                    <label class="form-label"><strong>Referensi Harga Beli</strong></label>
                    <textarea class="form-control referensi-harga" id="referensiHargaBox" rows="5" readonly 
                              placeholder="Ketik nama produk di tabel, lalu klik kolom harga beli untuk melihat referensi harga di sini. Klik pada textarea ini untuk memilih harga."></textarea>
                </div>
            </div>
            
            <form method="POST" id="draftForm">
                <!-- Header Information -->
                <div class="row mb-4 no-print">
                    <div class="col-md-3">
                        <label class="form-label">Tanggal <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="tanggal" value="<?php echo $edit_mode ? $draft['tanggal'] : date('Y-m-d'); ?>" required>
                    </div>
                    <!-- Ganti bagian dropdown customer yang ada dengan kode ini -->
<div class="col-md-6">
    <label class="form-label">Customer <span class="text-danger">*</span></label>
    <div class="dropdown">
        <input type="hidden" name="customer_id" id="selectedCustomerId" value="<?php echo $edit_mode ? $draft['customer_id'] : ''; ?>" required>
        <input type="text" 
               class="form-control dropdown-toggle" 
               id="customerSearch" 
               placeholder="Ketik nama customer untuk mencari..." 
               data-bs-toggle="dropdown" 
               aria-expanded="false"
               value="<?php 
                   if ($edit_mode) {
                       // Reset query result untuk get customer name
                       mysqli_data_seek($customers_result, 0);
                       while ($customer = mysqli_fetch_assoc($customers_result)) {
                           if ($customer['id'] == $draft['customer_id']) {
                               echo $customer['kode'] . ' - ' . $customer['nama'] . 
                                   (!empty($customer['nama_toko']) ? ' (' . $customer['nama_toko'] . ')' : '') . 
                                   ' - ' . $customer['kota'];
                               break;
                           }
                       }
                   }
               ?>"
               autocomplete="off">
        
        <ul class="dropdown-menu w-100" id="customerDropdown" style="max-height: 300px; overflow-y: auto;">
            <li class="px-3 py-2">
                <small class="text-muted">Ketik untuk mencari customer...</small>
            </li>
            <?php 
            // Reset query result
            mysqli_data_seek($customers_result, 0);
            while ($customer = mysqli_fetch_assoc($customers_result)): 
            ?>
            <li>
                <a class="dropdown-item customer-option" 
                   href="#" 
                   data-customer-id="<?php echo $customer['id']; ?>"
                   data-customer-text="<?php echo $customer['kode'] . ' - ' . $customer['nama'] . 
                       (!empty($customer['nama_toko']) ? ' (' . $customer['nama_toko'] . ')' : '') . 
                       ' - ' . $customer['kota']; ?>">
                    <div>
                        <strong><?php echo $customer['kode']; ?> - <?php echo $customer['nama']; ?></strong>
                        <?php if (!empty($customer['nama_toko'])): ?>
                            <br><small class="text-muted"><?php echo $customer['nama_toko']; ?></small>
                        <?php endif; ?>
                        <br><small class="text-info"><?php echo $customer['kota']; ?></small>
                    </div>
                </a>
            </li>
            <?php endwhile; ?>
        </ul>
    </div>
</div>
                    <div class="col-md-3">
                        <label class="form-label">Keterangan</label>
                        <textarea class="form-control" name="keterangan" rows="2" placeholder="Keterangan tambahan..."><?php echo $edit_mode ? htmlspecialchars($draft['keterangan']) : ''; ?></textarea>
                    </div>
                </div>

                <!-- Detail Items Table -->
                <div class="table-responsive">
                    <table class="table table-bordered table-input" id="itemsTable">
                        <thead class="table-dark">
                            <tr>
                                <th width="4%">No</th>
                                <th width="25%">Nama Barang</th>
                                <th width="8%">Jumlah</th>
                                <th width="12%">Harga Jual</th>
                                <th width="12%" class="no-print">Harga Beli</th>
                                <th width="8%" class="no-print">Margin Rp</th>
                                <th width="6%" class="no-print">Margin %</th>
                                <th width="10%" class="no-print">Keuntungan</th>
                                <th width="12%">Sub Total</th>
                                <th width="6%" class="no-print">Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="itemsBody">
                            <?php if ($edit_mode && !empty($details)): ?>
                                <?php foreach ($details as $index => $detail): ?>
                                <tr>
                                    <td><?php echo $index + 1; ?></td>
                                    <td>
                                        <input type="text" class="form-control nama-barang" name="nama_barang[]" 
                                               value="<?php echo htmlspecialchars($detail['nama_barang']); ?>" placeholder="Ketik nama barang...">
                                    </td>
                                    <td><input type="number" class="form-control jumlah" name="jumlah[]" step="0.01" min="0" value="<?php echo $detail['jumlah']; ?>"></td>
                                    <td><input type="number" class="form-control harga-jual" name="harga_jual[]" step="0.01" min="0" value="<?php echo $detail['harga_jual']; ?>"></td>
                                    <td class="no-print"><input type="number" class="form-control harga-beli" name="harga_beli[]" step="0.01" min="0" value="<?php echo $detail['harga_beli']; ?>"></td>
                                    <td class="no-print"><input type="text" class="form-control margin-rp" readonly value="<?php echo number_format($detail['margin_rupiah'], 0, ',', '.'); ?>"></td>
                                    <td class="no-print"><input type="text" class="form-control margin-persen" readonly value="<?php echo number_format($detail['margin_persen'], 2); ?>%"></td>
                                    <td class="no-print"><input type="text" class="form-control keuntungan-baris" readonly value="<?php echo number_format($detail['jumlah'] * $detail['margin_rupiah'], 0, ',', '.'); ?>"></td>
                                    <td><input type="text" class="form-control sub-total" readonly value="<?php echo number_format($detail['sub_total'], 0, ',', '.'); ?>"></td>
                                    <td class="no-print"><button type="button" class="btn btn-danger btn-sm remove-row">Hapus</button></td>
                                </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                            <tr>
                                <td>1</td>
                                <td>
                                    <input type="text" class="form-control nama-barang" name="nama_barang[]" placeholder="Ketik nama barang...">
                                </td>
                                <td><input type="number" class="form-control jumlah" name="jumlah[]" step="0.01" min="0"></td>
                                <td><input type="number" class="form-control harga-jual" name="harga_jual[]" step="0.01" min="0"></td>
                                <td class="no-print"><input type="number" class="form-control harga-beli" name="harga_beli[]" step="0.01" min="0"></td>
                                <td class="no-print"><input type="text" class="form-control margin-rp" readonly></td>
                                <td class="no-print"><input type="text" class="form-control margin-persen" readonly></td>
                                <td class="no-print"><input type="text" class="form-control keuntungan-baris" readonly></td>
                                <td><input type="text" class="form-control sub-total" readonly></td>
                                <td class="no-print"><button type="button" class="btn btn-danger btn-sm remove-row">Hapus</button></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="row mt-3 no-print">
                    <div class="col-md-6">
                        <button type="button" class="btn btn-secondary" id="addRow">
                            Tambah Baris
                        </button>
                    </div>
                    <div class="col-md-6 text-end">
                        <div class="mb-2">
                            <strong>Total Penjualan: <span id="grandTotal">Rp <?php echo $edit_mode ? number_format($draft['total_amount'], 0, ',', '.') : '0'; ?></span></strong>
                        </div>
                        <div class="mb-2">
                            <strong style="color: #28a745;">Total Keuntungan: <span id="totalProfit">Rp 0</span></strong>
                        </div>
                        <div>
                            <small>Margin Keseluruhan: <span id="overallMargin" style="font-weight: bold;">0%</span></small>
                        </div>
                    </div>
                </div>

                <div class="row mt-4 no-print">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary me-2">
                            <?php echo $edit_mode ? 'Simpan Perubahan' : 'Simpan Draft'; ?>
                        </button>
                        <a href="draft_penjualan_list.php" class="btn btn-secondary">
                            Kembali
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        let rowCounter = <?php echo $edit_mode ? count($details) : 1; ?>;
        let currentPriceData = [];
        let lastActiveRow = null; // Track which row requested price recommendations

        $(document).ready(function() {
            // Calculate initial values for edit mode
            <?php if ($edit_mode): ?>
            $('#itemsBody tr').each(function() {
                calculateRowTotals($(this));
            });
            calculateProfitSummary(); // Add initial profit calculation
            <?php endif; ?>
            
            // Add new row
            $('#addRow').click(function() {
                rowCounter++;
                let newRow = createNewRow(rowCounter);
                $('#itemsBody').append(newRow);
                attachEventHandlers();
                updateRowNumbers();
            });

            // Remove row
            $(document).on('click', '.remove-row', function() {
                if ($('#itemsBody tr').length > 1) {
                    $(this).closest('tr').remove();
                    updateRowNumbers();
                    calculateGrandTotal();
                    calculateProfitSummary(); // Add profit calculation
                }
            });

            // Copy to WhatsApp (Edit mode only)
            <?php if ($edit_mode): ?>
            $('#copyWABtn').click(function() {
                let waText = generateWAText();
                navigator.clipboard.writeText(waText).then(function() {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: 'Teks telah disalin ke clipboard. Silakan paste ke WhatsApp.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }).catch(function() {
                    // Fallback for older browsers
                    let textArea = document.createElement('textarea');
                    textArea.value = waText;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: 'Teks telah disalin ke clipboard. Silakan paste ke WhatsApp.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                });
            });
            <?php endif; ?>

            // Click referensi harga box to select price
            $('#referensiHargaBox').click(function() {
                if (currentPriceData.length > 0) {
                    showPriceSelector();
                }
            });

            attachEventHandlers();
        });

        <?php if ($edit_mode): ?>
        function generateWAText() {
            let text = "Penawaran Harga:\n\n";
            let no = 1;
            let totalPenjualan = 0;
            
            $('#itemsBody tr').each(function() {
                let namaBarang = $(this).find('.nama-barang').val().trim();
                let jumlah = parseFloat($(this).find('.jumlah').val()) || 0;
                let hargaJual = parseFloat($(this).find('.harga-jual').val()) || 0;
                
                if (namaBarang && jumlah > 0 && hargaJual > 0) {
                    let subTotal = jumlah * hargaJual;
                    text += `${no}. ${namaBarang} (${jumlah}) - Rp ${numberFormat(hargaJual)}\n`;
                    totalPenjualan += subTotal;
                    no++;
                }
            });
            
            // Tambahkan total di bagian akhir
            text += `\n*TOTAL: Rp ${numberFormat(totalPenjualan)}*`;
            
            return text;
        }
        <?php endif; ?>

        function createNewRow(num) {
            return `
                <tr>
                    <td>${num}</td>
                    <td>
                        <input type="text" class="form-control nama-barang" name="nama_barang[]" placeholder="Ketik nama barang...">
                    </td>
                    <td><input type="number" class="form-control jumlah" name="jumlah[]" step="0.01" min="0"></td>
                    <td><input type="number" class="form-control harga-jual" name="harga_jual[]" step="0.01" min="0"></td>
                    <td class="no-print"><input type="number" class="form-control harga-beli" name="harga_beli[]" step="0.01" min="0"></td>
                    <td class="no-print"><input type="text" class="form-control margin-rp" readonly></td>
                    <td class="no-print"><input type="text" class="form-control margin-persen" readonly></td>
                    <td class="no-print"><input type="text" class="form-control keuntungan-baris" readonly></td>
                    <td><input type="text" class="form-control sub-total" readonly></td>
                    <td class="no-print"><button type="button" class="btn btn-danger btn-sm remove-row">Hapus</button></td>
                </tr>
            `;
        }

        function attachEventHandlers() {
            // Load price recommendations when user clicks on harga-beli field
            $('.harga-beli').off('focus').on('focus', function() {
                let row = $(this).closest('tr');
                let productName = row.find('.nama-barang').val().trim();
                lastActiveRow = row; // Store the active row
                if (productName) {
                    loadPriceRecommendations(productName);
                }
            });

            // Also load when user finishes typing product name
            $('.nama-barang').off('blur').on('blur', function() {
                let productName = $(this).val().trim();
                let row = $(this).closest('tr');
                lastActiveRow = row; // Store the active row
                if (productName) {
                    loadPriceRecommendations(productName);
                }
            });

            // Calculate margins and totals
            $('.jumlah, .harga-jual, .harga-beli').off('input').on('input', function() {
                calculateRowTotals($(this).closest('tr'));
                calculateGrandTotal();
                calculateProfitSummary(); // Add profit calculation
            });
        }

        function loadPriceRecommendations(productName) {
            let referensiBox = $('#referensiHargaBox');
            referensiBox.val('Loading referensi harga untuk "' + productName + '"...');
            
            $.ajax({
                url: 'get_price_recommendations.php',
                method: 'GET',
                data: { product: productName },
                dataType: 'json',
                success: function(data) {
                    currentPriceData = data;
                    if (data.length > 0) {
                        let referensiText = 'REFERENSI HARGA BELI untuk "' + productName + '":\n\n';
                        data.forEach(function(item, index) {
                            referensiText += (index + 1) + '. ' + item.supplier + ' = Rp ' + numberFormat(item.harga) + '\n';
                        });
                        referensiText += '\n** KLIK DI SINI UNTUK MEMILIH HARGA **';
                        referensiBox.val(referensiText);
                    } else {
                        referensiBox.val('Tidak ada referensi harga untuk "' + productName + '"');
                        currentPriceData = [];
                    }
                },
                error: function() {
                    referensiBox.val('Error loading referensi harga');
                    currentPriceData = [];
                }
            });
        }

        function showPriceSelector() {
            if (currentPriceData.length === 0) return;
            
            let options = 'Pilih harga yang akan digunakan:\n\n';
            currentPriceData.forEach(function(item, index) {
                options += (index + 1) + '. ' + item.supplier + ' - Rp ' + numberFormat(item.harga) + '\n';
            });
            
            let selection = prompt(options + '\nMasukkan nomor pilihan (1-' + currentPriceData.length + '):');
            if (selection) {
                let index = parseInt(selection) - 1;
                if (index >= 0 && index < currentPriceData.length) {
                    let selectedPrice = currentPriceData[index].harga;
                    
                    // Use the last active row that loaded price recommendations
                    if (lastActiveRow && lastActiveRow.length > 0) {
                        lastActiveRow.find('.harga-beli').val(selectedPrice).trigger('input');
                        alert('Harga Rp ' + numberFormat(selectedPrice) + ' dari ' + currentPriceData[index].supplier + ' berhasil dimasukkan');
                    } else {
                        alert('Tidak dapat menentukan baris yang aktif. Silakan klik pada kolom Harga Beli terlebih dahulu.');
                    }
                }
            }
        }

        function calculateRowTotals(row) {
            let jumlah = parseFloat(row.find('.jumlah').val()) || 0;
            let hargaJual = parseFloat(row.find('.harga-jual').val()) || 0;
            let hargaBeli = parseFloat(row.find('.harga-beli').val()) || 0;
            
            let marginRp = hargaJual - hargaBeli;
            let marginPersen = hargaBeli > 0 ? (marginRp / hargaBeli * 100) : 0;
            let subTotal = jumlah * hargaJual;
            let keuntunganBaris = jumlah * marginRp;
            
            row.find('.margin-rp').val(numberFormat(marginRp));
            row.find('.margin-persen').val(marginPersen.toFixed(2) + '%');
            row.find('.keuntungan-baris').val(numberFormat(keuntunganBaris));
            row.find('.sub-total').val(numberFormat(subTotal));
            
            // Color coding for margin percentage
            let marginPersenInput = row.find('.margin-persen');
            marginPersenInput.removeClass('margin-red margin-yellow margin-green');
            
            if (marginPersen < 1) {
                marginPersenInput.addClass('margin-red');
            } else if (marginPersen <= 5) {
                marginPersenInput.addClass('margin-yellow');
            } else {
                marginPersenInput.addClass('margin-green');
            }
        }

        function calculateGrandTotal() {
            let total = 0;
            $('#itemsBody tr').each(function() {
                let jumlah = parseFloat($(this).find('.jumlah').val()) || 0;
                let hargaJual = parseFloat($(this).find('.harga-jual').val()) || 0;
                total += (jumlah * hargaJual);
            });
            $('#grandTotal').text('Rp ' + numberFormat(total));
        }

        function calculateProfitSummary() {
            let totalProfit = 0;
            let totalModal = 0;
            let totalPenjualan = 0;
            
            $('#itemsBody tr').each(function() {
                let jumlah = parseFloat($(this).find('.jumlah').val()) || 0;
                let hargaJual = parseFloat($(this).find('.harga-jual').val()) || 0;
                let hargaBeli = parseFloat($(this).find('.harga-beli').val()) || 0;
                
                if (jumlah > 0 && hargaJual > 0 && hargaBeli > 0) {
                    let modalBaris = jumlah * hargaBeli;
                    let penjualanBaris = jumlah * hargaJual;
                    let profitBaris = penjualanBaris - modalBaris;
                    
                    totalModal += modalBaris;
                    totalPenjualan += penjualanBaris;
                    totalProfit += profitBaris;
                }
            });
            
            // Update total profit display
            $('#totalProfit').text('Rp ' + numberFormat(totalProfit));
            
            // Hitung margin keseluruhan
            let overallMargin = totalModal > 0 ? (totalProfit / totalModal * 100) : 0;
            let marginSpan = $('#overallMargin');
            marginSpan.text(overallMargin.toFixed(2) + '%');
            
            // Color coding untuk margin keseluruhan
            marginSpan.removeClass('text-danger text-warning text-success');
            if (overallMargin < 1) {
                marginSpan.addClass('text-danger'); // Merah
            } else if (overallMargin <= 5) {
                marginSpan.addClass('text-warning'); // Kuning/orange
            } else {
                marginSpan.addClass('text-success'); // Hijau
            }
        }

        function updateRowNumbers() {
            $('#itemsBody tr').each(function(index) {
                $(this).find('td:first').text(index + 1);
            });
            rowCounter = $('#itemsBody tr').length;
        }

        function numberFormat(number) {
            return new Intl.NumberFormat('id-ID').format(number);
        }

        // Form validation
        $('#draftForm').submit(function(e) {
            let hasItems = false;
            $('#itemsBody tr').each(function() {
                let namaBarang = $(this).find('.nama-barang').val().trim();
                let jumlah = parseFloat($(this).find('.jumlah').val()) || 0;
                let hargaJual = parseFloat($(this).find('.harga-jual').val()) || 0;
                
                if (namaBarang && jumlah > 0 && hargaJual > 0) {
                    hasItems = true;
                    return false;
                }
            });
            
            if (!hasItems) {
                e.preventDefault();
                alert('Mohon tambahkan minimal 1 item yang valid!');
            }
        });
        
        $(document).ready(function() {
    // Customer search functionality
    let customerOptions = [];
    
    // Store all customer options
    $('.customer-option').each(function() {
        customerOptions.push({
            id: $(this).data('customer-id'),
            text: $(this).data('customer-text'),
            element: $(this).parent()
        });
    });
    
    // Search input handler
    $('#customerSearch').on('input', function() {
        let searchTerm = $(this).val().toLowerCase();
        let dropdown = $('#customerDropdown');
        
        // Clear previous selections
        $('#selectedCustomerId').val('');
        
        // Show dropdown when user types
        if (!dropdown.hasClass('show')) {
            $(this).dropdown('show');
        }
        
        // Filter options
        $('.customer-option').parent().hide();
        let visibleCount = 0;
        
        customerOptions.forEach(function(option) {
            if (option.text.toLowerCase().includes(searchTerm)) {
                option.element.show();
                visibleCount++;
            }
        });
        
        // Show "no results" message if needed
        if (visibleCount === 0 && searchTerm.length > 0) {
            if ($('#noResults').length === 0) {
                dropdown.append('<li id="noResults" class="px-3 py-2 text-muted"><small>Tidak ada customer yang ditemukan</small></li>');
            }
        } else {
            $('#noResults').remove();
        }
    });
    
    // Handle customer selection
    $(document).on('click', '.customer-option', function(e) {
        e.preventDefault();
        
        let customerId = $(this).data('customer-id');
        let customerText = $(this).data('customer-text');
        
        $('#selectedCustomerId').val(customerId);
        $('#customerSearch').val(customerText);
        
        // Close dropdown
        $('#customerSearch').dropdown('hide');
        
        // Remove validation error styling if present
        $('#customerSearch').removeClass('is-invalid');
    });
    
    // Handle dropdown show/hide
    $('#customerSearch').on('focus', function() {
        $(this).dropdown('show');
    });
    
    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('#customerSearch').dropdown('hide');
        }
    });
    
    // Keyboard navigation
    let currentIndex = -1;
    $('#customerSearch').on('keydown', function(e) {
        let visibleOptions = $('.customer-option:visible');
        
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            currentIndex = Math.min(currentIndex + 1, visibleOptions.length - 1);
            updateSelection(visibleOptions);
        } else if (e.key === 'ArrowUp') {
            e.preventDefault();
            currentIndex = Math.max(currentIndex - 1, -1);
            updateSelection(visibleOptions);
        } else if (e.key === 'Enter') {
            e.preventDefault();
            if (currentIndex >= 0 && currentIndex < visibleOptions.length) {
                $(visibleOptions[currentIndex]).click();
            }
        } else if (e.key === 'Escape') {
            $(this).dropdown('hide');
            currentIndex = -1;
        } else {
            currentIndex = -1; // Reset when typing
        }
    });
    
    function updateSelection(visibleOptions) {
        // Remove previous selections
        $('.customer-option').removeClass('active');
        
        // Add selection to current item
        if (currentIndex >= 0 && currentIndex < visibleOptions.length) {
            $(visibleOptions[currentIndex]).addClass('active');
        }
    }
    
    // Form validation - make sure customer is selected
    $('#draftForm').on('submit', function(e) {
        if (!$('#selectedCustomerId').val()) {
            e.preventDefault();
            $('#customerSearch').addClass('is-invalid');
            alert('Mohon pilih customer terlebih dahulu!');
            $('#customerSearch').focus();
            return false;
        }
    });
    
    // Clear validation error when user starts typing
    $('#customerSearch').on('input', function() {
        $(this).removeClass('is-invalid');
    });
});
    </script>
</body>
</html>