<?php
include 'config.php';
include 'session.php';

$draft_id = $_GET['draft_id'] ?? 0;

if (!$draft_id) {
    header("Location: draft_penjualan_list.php?error=ID draft tidak valid");
    exit;
}

try {
    mysqli_begin_transaction($conn);

    // Ambil data draft
    $draft_query = "SELECT * FROM draft_penjualan WHERE id = '$draft_id' AND status = 'draft'";
    $draft_result = mysqli_query($conn, $draft_query);

    if (mysqli_num_rows($draft_result) == 0) {
        throw new Exception("Draft tidak ditemukan atau sudah dikonversi");
    }

    $draft = mysqli_fetch_assoc($draft_result);

    // Generate nomor invoice untuk penjualan
    $q = mysqli_query($conn, "SHOW TABLE STATUS LIKE 'penjualan'");
    $row = mysqli_fetch_assoc($q);
    $next_id = $row['Auto_increment'] ?? 1;

    $bulan_ini = date('Ym');
    $next = str_pad($next_id, 4, '0', STR_PAD_LEFT);
    $no_invoice = "INV-$bulan_ini-$next";

    // Insert ke tabel penjualan
    $insert_penjualan = "INSERT INTO penjualan (
        no_invoice, tanggal, jenis, customer_id, rekening, 
        grand_total, draft_id
    ) VALUES (
        '$no_invoice', 
        '{$draft['tanggal']}', 
        'non PPN', 
        '{$draft['customer_id']}', 
        'Rekening A', 
        '{$draft['grand_total']}', 
        '$draft_id'
    )";

    if (!mysqli_query($conn, $insert_penjualan)) {
        throw new Exception("Gagal membuat penjualan: " . mysqli_error($conn));
    }

    $penjualan_id = mysqli_insert_id($conn);

    // Ambil detail draft
    $detail_query = "SELECT * FROM draft_penjualan_detail WHERE draft_penjualan_id = '$draft_id'";
    $detail_result = mysqli_query($conn, $detail_query);

    // Insert detail ke penjualan_detail
    while ($detail = mysqli_fetch_assoc($detail_result)) {
        $insert_detail = "INSERT INTO penjualan_detail (
            penjualan_id, produk_id, qty, satuan, harga, 
            total, supplier, harga_beli
        ) VALUES (
            '$penjualan_id',
            '{$detail['produk_id']}',
            '{$detail['qty']}',
            '{$detail['satuan']}',
            '{$detail['harga']}',
            '{$detail['total']}',
            '{$detail['supplier']}',
            '{$detail['harga_beli']}'
        )";

        if (!mysqli_query($conn, $insert_detail)) {
            throw new Exception("Gagal menyimpan detail penjualan: " . mysqli_error($conn));
        }
    }

    // Update status draft menjadi 'converted'
    $update_draft = "UPDATE draft_penjualan 
                     SET status = 'converted', 
                         converted_at = NOW(), 
                         penjualan_id = '$penjualan_id' 
                     WHERE id = '$draft_id'";

    if (!mysqli_query($conn, $update_draft)) {
        throw new Exception("Gagal update status draft: " . mysqli_error($conn));
    }

    mysqli_commit($conn);

    // Redirect ke halaman edit penjualan yang baru dibuat
    header("Location: penjualan.php?id=$penjualan_id&success=Berhasil konversi draft ke penjualan dengan nomor $no_invoice");
    exit;

} catch (Exception $e) {
    mysqli_rollback($conn);
    
    error_log("Error konversi draft: " . $e->getMessage());
    
    header("Location: draft_penjualan_list.php?error=" . urlencode($e->getMessage()));
    exit;
}
?>