<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

$id = $_GET['id'] ?? 0;
$data = [
    'no_draft' => '',
    'tanggal' => date('Y-m-d'),
    'jenis' => '',
    'rekening' => '',
    'customer_id' => '',
    'customer_nama' => '',
    'grand_total' => 0
];
$produk_list = [];

if ($id) {
    $q = mysqli_query($conn, "SELECT d.*, c.nama as customer_nama 
        FROM penjualan_draft d
        LEFT JOIN customer c ON d.customer_id = c.id
        WHERE d.id='$id'");
    if ($row = mysqli_fetch_assoc($q)) {
        $data = $row;
    }

    $q_detail = mysqli_query($conn, "SELECT * FROM penjualan_draft_detail WHERE draft_id='$id'");
    while ($row = mysqli_fetch_assoc($q_detail)) {
        $row['produk_nama'] = ''; // Jika mau load nama produk bisa join tabel produk
        $produk_list[] = $row;
    }
}
?>
<div class="container mt-4">
    <h3><?= $id ? "Edit" : "Tambah" ?> Penjualan Draft</h3>
    <form action="penjualan_draft_simpan.php" method="post">
        <input type="hidden" name="id" value="<?= $id ?>">

        <div class="row mb-3">
            <div class="col-md-4">
                <label>No. Draft</label>
                <input type="text" name="no_draft" class="form-control" value="<?= $data['no_draft'] ?>" required>
            </div>
            <div class="col-md-4">
                <label>Tanggal</label>
                <input type="date" name="tanggal" class="form-control" value="<?= $data['tanggal'] ?>" required>
            </div>
            <div class="col-md-4">
                <label>Jenis</label>
                <input type="text" name="jenis" class="form-control" value="<?= $data['jenis'] ?>">
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                <label>Rekening</label>
                <input type="text" name="rekening" class="form-control" value="<?= $data['rekening'] ?>">
            </div>
            <div class="col-md-8">
                <label>Customer</label>
                <input type="hidden" name="customer_id" value="<?= $data['customer_id'] ?>">
                <input type="text" class="form-control" value="<?= htmlspecialchars($data['customer_nama']) ?>" readonly>
            </div>
        </div>

        <h5>Detail Produk</h5>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Produk</th>
                    <th>Jumlah</th>
                    <th>Unit</th>
                    <th>Harga Jual</th>
                    <th>Supplier</th>
                    <th>Harga Beli</th>
                    <th>Nota</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody id="produkBody">
                <?php if (!empty($produk_list)) : ?>
                    <?php foreach ($produk_list as $p) : ?>
                    <tr>
                        <td>
                            <input type="hidden" name="produk_id[]" value="<?= $p['produk_id'] ?>">
                            <input type="text" name="produk_nama[]" class="form-control" value="<?= htmlspecialchars($p['produk_nama']) ?>">
                        </td>
                        <td><input type="number" name="jumlah[]" class="form-control" value="<?= $p['qty'] ?>"></td>
                        <td><input type="text" name="unit[]" class="form-control" value="<?= htmlspecialchars($p['satuan'] ?: 'Dos') ?>"></td>
                        <td><input type="number" name="harga_jual[]" class="form-control" value="<?= $p['harga'] ?>"></td>
                        <td><input type="text" name="supplier[]" class="form-control" value="<?= htmlspecialchars($p['supplier']) ?>"></td>
                        <td><input type="number" name="harga_beli[]" class="form-control" value="<?= $p['harga_beli'] ?>"></td>
                        <td><input type="text" name="nota_nama[]" class="form-control" value="<?= htmlspecialchars($p['nota']) ?>"></td>
                        <td><button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button></td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary btn-sm" onclick="addRow()">+ Tambah Produk</button>

        <div class="mt-4">
            <button type="submit" class="btn btn-success">Simpan</button>
            <a href="penjualan_draft_list.php" class="btn btn-secondary">List Draft</a>
        </div>
    </form>
</div>

<script>
function addRow() {
    let row = `
    <tr>
        <td>
            <input type="hidden" name="produk_id[]" value="">
            <input type="text" name="produk_nama[]" class="form-control">
        </td>
        <td><input type="number" name="jumlah[]" class="form-control"></td>
        <td><input type="text" name="unit[]" class="form-control" value="Dos"></td>
        <td><input type="number" name="harga_jual[]" class="form-control"></td>
        <td><input type="text" name="supplier[]" class="form-control"></td>
        <td><input type="number" name="harga_beli[]" class="form-control"></td>
        <td><input type="text" name="nota_nama[]" class="form-control"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button></td>
    </tr>`;
    document.getElementById('produkBody').insertAdjacentHTML('beforeend', row);
}

function hapusRow(btn) {
    btn.closest('tr').remove();
}
</script>
