<?php
include 'config.php';
include 'session.php';

// Ambil ID dari parameter GET
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Validasi ID
if ($id <= 0) {
    echo "<script>
        alert('ID penjualan tidak valid!');
        window.location.href = 'penjualan_list.php';
    </script>";
    exit;
}

// Cek apakah transaksi ada dan statusnya belum bayar
$check_query = "SELECT id, no_invoice, status_bayar FROM penjualan WHERE id = '$id'";
$check_result = mysqli_query($conn, $check_query);

if (!$check_result || mysqli_num_rows($check_result) == 0) {
    echo "<script>
        alert('Data penjualan tidak ditemukan!');
        window.location.href = 'penjualan_list.php';
    </script>";
    exit;
}

$data = mysqli_fetch_assoc($check_result);

// Validasi: hanya boleh hapus jika belum bayar
if ($data['status_bayar'] == 'lunas') {
    echo "<script>
        alert('Tidak dapat menghapus transaksi yang sudah LUNAS!\\nNo Invoice: " . htmlspecialchars($data['no_invoice']) . "');
        window.location.href = 'penjualan_list.php';
    </script>";
    exit;
}

// Mulai transaction untuk memastikan data consistency
mysqli_begin_transaction($conn);

try {
    // 1. Hapus detail penjualan terlebih dahulu (child records)
    $delete_detail_query = "DELETE FROM penjualan_detail WHERE penjualan_id = '$id'";
    $delete_detail = mysqli_query($conn, $delete_detail_query);
    
    if (!$delete_detail) {
        throw new Exception("Gagal menghapus detail penjualan: " . mysqli_error($conn));
    }
    
    // 2. Hapus header penjualan
    $delete_header_query = "DELETE FROM penjualan WHERE id = '$id'";
    $delete_header = mysqli_query($conn, $delete_header_query);
    
    if (!$delete_header) {
        throw new Exception("Gagal menghapus penjualan: " . mysqli_error($conn));
    }
    
    // Commit transaction
    mysqli_commit($conn);
    
    // Success - redirect dengan pesan sukses
    echo "<script>
        alert('Penjualan " . htmlspecialchars($data['no_invoice']) . " berhasil dihapus!');
        window.location.href = 'penjualan_list.php';
    </script>";
    exit;
    
} catch (Exception $e) {
    // Rollback jika ada error
    mysqli_rollback($conn);
    
    // Error - redirect dengan pesan error
    echo "<script>
        alert('Gagal menghapus penjualan!\\nError: " . addslashes($e->getMessage()) . "');
        window.location.href = 'penjualan_list.php';
    </script>";
    exit;
}
?>