<?php
include 'config.php';

$nama = trim($_POST['nama'] ?? '');
$response = ['success' => false];

if ($nama !== '') {
    // Cek apakah nama produk sudah ada (case-insensitive)
    $check = mysqli_query($conn, "SELECT id, nama FROM produk_interest WHERE LOWER(nama) = LOWER('" . mysqli_real_escape_string($conn, $nama) . "') LIMIT 1");

    if (mysqli_num_rows($check) > 0) {
        $existing = mysqli_fetch_assoc($check);
        $response = [
            'success' => true,
            'id' => $existing['id'],
            'nama' => $existing['nama'],
            'message' => 'Produk sudah ada'
        ];
    } else {
        // Tambahkan produk baru
        $insert = mysqli_query($conn, "INSERT INTO produk_interest (nama) VALUES ('" . mysqli_real_escape_string($conn, $nama) . "')");
        if ($insert) {
            $response = [
                'success' => true,
                'id' => mysqli_insert_id($conn),
                'nama' => $nama,
                'message' => 'Produk berhasil ditambahkan'
            ];
        }
    }
}

header('Content-Type: application/json');
echo json_encode($response);
